#include <reg51.h>

//***  ***
void long_delay(void);							// ʱ
void short_delay(void);							// ʱ
void delay10ms(unsigned char);					// ʱ10MS
void write7279(unsigned char, unsigned char);	// д뵽HD7279
unsigned char read7279(unsigned char);			// HD7279
void send_byte(unsigned char);					// һֽ
unsigned char receive_byte(void);				// һֽ

//*** I/Oڶ ***
unsigned char digit[5];
unsigned char key_number, j, k;
unsigned int tmr;
unsigned long wait_cnter;
sbit cs=P1^4;					// cs at P1.4
sbit clk=P1^5;					// clk  P1.5
sbit dat=P1^2;					// dat  P1.2
sbit key=P1^3;					// key  P1.3

//****** HD7279A ָ ******
#define CMD_RESET 0xa4
#define CMD_TEST 0xbf
#define DECODE0 0x80
#define DECODE1 0xc8
#define CMD_READ 0x15
#define UNDECODE 0x90
#define RTL_CYCLE 0xa3
#define RTR_CYCLE 0xa2
#define RTL_UNCYL 0xa1
#define RTR_UNCYL 0xa0
#define ACTCTL 0x98
#define SEGON 0xe0
#define SEGOFF 0xc0
#define BLINKCTL 0x88

//***  ***
main()
{
	while (1)
	{
		for (tmr=0;tmr<0x2000;tmr++);	// ϵʱ
		send_byte(CMD_RESET);			// λHD7279A
		
//******************************************
//              ָʾ
//******************************************
		send_byte(CMD_TEST);				// ָ
		for (j=0;j<3;j++)					// ʱԼ3
		{
			delay10ms(100);
		}
		send_byte(CMD_RESET);				// ʾ

//**********************************************
//        ˸ָ̽ӿڲ
// ûļʾ, 10ް
// S0һʾ
//**********************************************
		wait_cnter=0;
		key_number=0xff;
		write7279(BLINKCTL,0xfc);			// 12λΪ˸ʾ
		write7279(UNDECODE,0X08);			// ڵ1λʾ»'_'
		write7279(UNDECODE+1,0x08);			// ڵ2λʾ»'_'
		do
		{
			if (!key)						// м
			{
				key_number=read7279(CMD_READ);			// 
				write7279(DECODE1+1,key_number/16);		// ڵ2λʾ8λ
				write7279(DECODE1,key_number&0x0f);		// ڵ1λʾ8λ
				while (!key);							// ȴſ
				wait_cnter=0;
			}
			wait_cnter++;
		} while (key_number!=0 && wait_cnter<0x30000);	// Ϊ0ͳʱһʾ
		write7279(BLINKCTL,0xff);						// ˸

//******************************************
//            ټʾ
//******************************************
		for (j=0;j<5;j++)					// ʼֵΪ00000
		{
			digit[j]=0;
			write7279(DECODE0+j,digit[j]);
		}
		while (digit[4]<2)					// ﵽ20000ֹͣ
		{
			digit[0]++;
			if (digit[0]>9)
			{
				digit[0]=0;
				digit[1]++;
				if (digit[1]>9)
				{
					digit[1]=0;
					digit[2]++;
					if (digit[2]>9)
					{
						digit[2]=0;
						digit[3]++;
						if (digit[3]>9)
						{
							digit[3]=0;
							digit[4]++;
							if (digit[4]>9)
							{
								digit[4]=0;
							}
						}
					}
				}
			}
			write7279(DECODE0,digit[0]);
			if (digit[0]==0)
			{
				write7279(DECODE0+1,digit[1]);
				if (digit[1]==0)
				{
					write7279(DECODE0+2,digit[2]);
					if (digit[2]==0)
					{
						write7279(DECODE0+3,digit[3]);
						if (digit[3]==0)
						{
							write7279(DECODE0+4,digit[4]);
						}
					}
				}
			}
		}
		delay10ms(150);
		send_byte(CMD_RESET);				// ʾ

//*************************************************
//         ݵָ
//*************************************************
		write7279(UNDECODE+7,0x49);			// ڵ8λ뷽ʽʾһַ''
		delay10ms(80);

//*************************************************
//               ѭ/Ʋ
//      ""˶3,˶3
//*************************************************
		for (j=0;j<23;j++)
		{
			send_byte(RTR_CYCLE);		// ѭ23
			delay10ms(12);
		}
		for (j=0;j<23;j++)
		{
			send_byte(RTL_CYCLE);		// ѭ23
			delay10ms(12);
		}

//*********************************************
//      뷽ʽ0ָ
//*********************************************
		for (j=0;j<16;j++)
		{
			send_byte(RTL_UNCYL);		// ѭָ
			write7279(DECODE0,j);		// 뷽ʽ0ָʾڵ1λ
			delay10ms(50);
		}
		delay10ms(150);
		send_byte(CMD_RESET);

//*********************************************
//      뷽ʽ1ָ
//*********************************************
		for (j=0;j<16;j++)
		{
			send_byte(RTR_UNCYL);		// ѭָ
			write7279(DECODE1+7,j);		// 뷽ʽ0ָʾڵ8λ
			delay10ms(50);
		}
		delay10ms(150);

//*********************************************
//              ָ
//*********************************************
		k=0xff;
		for (j=0;j<6;j++)
		{
			k=k/2;
			write7279(ACTCTL,k);		// ÿһһλ
			delay10ms(100);
		}
		write7279(ACTCTL,0xff);			// ָ8λʾ
		delay10ms(100);
		send_byte(CMD_RESET);			// ʾ
	
//**********************************************
//         εָͶιرָ
//**********************************************
		for (j=0;j<64;j++)
		{
			write7279(SEGON,j);			// 64ʾ
			write7279(SEGOFF,j-1);		// ͬʱǰһʾιر
			delay10ms(20);
		}
	}
}
	
void write7279(unsigned char cmd, unsigned char dta)
{
	send_byte (cmd);
	send_byte (dta);
}	

unsigned char read7279(unsigned char command)
{
	send_byte(command);
	return(receive_byte());
}

void send_byte(	unsigned char out_byte)
{
	unsigned char i;
	cs=0;
	long_delay();
	for (i=0;i<8;i++)
	{
		if (out_byte&0x80)
		{	
			dat=1;
		}
		else
		{
			dat=0;
		}
		clk=1;
		short_delay();
		clk=0;
		short_delay();
		out_byte=out_byte*2;
	}
	dat=0;
}

unsigned char receive_byte(void)
{
	unsigned char i, in_byte;
	dat=1;				// set to input mode
	long_delay();
	for (i=0;i<8;i++)
	{
		clk=1;
		short_delay();
		in_byte=in_byte*2;
		if (dat)
		{
			in_byte=in_byte|0x01;
		}
		clk=0;
		short_delay();
	}
	dat=0;
	return (in_byte);
}

void long_delay(void)
{
	unsigned char i;
	for (i=0;i<0x30;i++);
}

void short_delay(void)
{
	unsigned char i;
	for (i=0;i<8;i++);
}

// ************************* ʱ n*10ms *************************
void delay10ms(unsigned char time)
{
	unsigned char i;
	unsigned int j;
	for (i=0;i<time;i++)
	{
		for(j=0;j<0x390;j++)
		{
			if (!key)
			{
				key_int();
			}
		}
	}
}
