#include <at892051.h>

//***  ***
void delay(unsigned char);				// ʱ
void write728x(unsigned char, unsigned char);	// д뵽BC728x
unsigned char read728x(unsigned char);		// BC728x
void send_byte(unsigned char);			// һֽ
unsigned char receive_byte(void);			// һֽ
void delay10ms(unsigned char);
void key_int(void);

//*** I/Oڶ ***
unsigned char digit[5];
unsigned char key_number, j;
unsigned int tmr;
sbit clk=P3^5;		// clk  P3.5
sbit dat=P3^7;		// dat  P3.7
sbit key=P3^3;		// key  P3.3(INT1)


//***  ***
main()
{
	unsigned char i, disp_data, blink_ctl;
	delay10ms(20);				// ȴ BC728x ɸλ (200ms)
	write728x(0x12,0x88);		// ʼBC728xΪ164ģʽ,BMS=1, KMS=0

	while (1) {
// ************************ ټ ****************************	
	for (j=0;j<8;j++)
	{
		write728x(j,0xc0);		// ֱдʾĴ,0-7λʾΪ'0'
	}
	for (j=0;j<5;j++)			// ʼ
	{
		digit[j]=0;
	}
	while (digit[4]<1)			// ֵ10000
	{
		if (!key)
		{
			key_int();
		}
		digit[0]++;				// λ1
		if (digit[0]>9)			// жǷнλ
		{
			digit[0]=0;			// нλλ
			digit[1]++;			// ʮλһ
			if (digit[1]>9)
			{
				digit[1]=0;
				digit[2]++;
				if (digit[2]>9)
				{
					digit[2]=0;
					digit[3]++;
					if (digit[3]>9)
					{
						digit[3]=0;
						digit[4]++;
					}
				}
			}
		}
		write728x(0x14,digit[0]);			// ˢ¸λ
		if (digit[0]==0)					// λǷΪ㣿
		{
			write728x(0x14,0x10+digit[1]);	// λΪ㣬ʾнλˢʮλ
			if (digit[1]==0)				// ʮλǷΪ㣿
			{
				write728x(0x14,0x20+digit[2]);	// ʮλΪ㣬ˢ°λ
				if (digit[2]==0)
				{
					write728x(0x14,0x30+digit[3]);
					if (digit[3]==0)
					{
						write728x(0x15,0x40+digit[4]);
					}
				}
			}
		}
	}
//********************* ĴֱӶд ************************
	delay10ms(100);
	write728x(0x16,0);				// ʾ
	write728x(0x17,0);
	write728x(0,0xb6);				// ڵ0λʾһ
	delay10ms(100);
	for (i=0;i<0x0f;i++)
	{
		disp_data=read728x(i);		// ʾĴ
		write728x(i+1,disp_data);	// дһλ
		write728x(i,0xff);			// ǰһλ
		delay10ms(15);				// ʱ
	}
	for (i=0x0f;i>0;i--)
	{
		disp_data=read728x(i);		// ʾĴ
		write728x(i-1,disp_data);	// дǰһλ
		write728x(i,0xff);			// ǰλ
		delay10ms(10);				// ʱ200ms
	}
// ********************* hex  *****************************
	for (i=0;i<0x10;i++)
	{
		write728x(0x15,i*16+i);		// 0-15λֱʾ0-F
		delay10ms(50);				// ʱ1s
	}
// ********************* ˸ܲ *****************************
	write728x(0x12,0x80);			// BMS=0
	blink_ctl=0xff;
	write728x(0x12,0x80);		
	for (i=0;i<8;i++)				// ÿһһ˸λֱȫ˸
	{
		blink_ctl=blink_ctl/2;
		write728x(0x10,blink_ctl);
		delay10ms(150);
	}
	write728x(0x12,0x88);			// BC728xΪ164ģʽ,BMS=1, KMS=0
	write728x(0x10,0x5f);			// 57λ˸
	delay10ms(150);					// ʱ
	write728x(0x19,0xaf);			// 1214λ˸
	delay10ms(150);
	disp_data=read728x(0x11);		// ˸ٶȿƼĴ
	write728x(0,0xff);				// 0-3λʾ
	write728x(1,0xff);
	write728x(2,0xff);
	write728x(3,0xff);
	
	for (i=disp_data;i>0;i--)		// ˸ٶȲԡٶ𽥼ӿ
	{
		write728x(0x15,(i-1)&0x0f);	// ڵ0͵1λ˸ٶȿƼĴֵ
		write728x(0x15,(((i-1)&0xf0)/16)|0x10);
		write728x(0x11,i-1);		// ˸ٶȼĴ
		delay10ms(25);				// ʱ250ms
	}
	delay10ms(200);					// ʱ2s
	
	for (i=0;i<0xff;i++)			// ˸ٶȲԡٶ𽥼
	{
		write728x(0x15,(i+1)&0x0f);	// ڵ0͵1λ˸ٶȿƼĴֵ
		write728x(0x15,(((i+1)&0xf0)/16)|0x10);
		write728x(0x11,i+1);		// ˸ٶȼĴ
		delay10ms(25);
	}
	delay10ms(200);
	write728x(0x10,0xff);			// ֹͣ˸
	write728x(0x19,0xff);
	write728x(0x11,0x40);			// ˸ĴΪʼֵ

// *****************************  *****************************
	for (i=0;i<=0x40;i++)
	{
		write728x(0x16,0x40-i);		// һݼʾ
		write728x(0x17,i);			// ʾ
		delay10ms(10);
	}
/*	for (i=0;i<=0x40;i++)
	{
		write728x(0x16,i);		// һݼʾ
		write728x(0x17,0x40-i);			// ʾ
		delay10ms(10);
	}
*/
// ***************************** Ѱַ ******************************
	write728x(0x17,0);				//     ʾ
	for (i=0;i<0x80;i++)			// ӵ0οʼϨ
	{
		write728x(0x18,i);			// ε
		delay10ms(10);
		write728x(0x18,i|0x80);		// Ϩ
	}
// ******************************** ̲ ****************************
//	write728x(0x12,0x88);			// ΪBMS=1, KMS=0
//	write728x(0x19,0xff);
//	write728x(8,0xf7);				// ڵ8λʾ"_"
//	key_int();
//	write728x(0x10,0xff);			// ֹͣ˸
	}
}


void key_int(void)
{
	unsigned long timer;
	unsigned char n, kms;
	while (1)
	{
		timer=0;
		while(key && timer<0xf000)					// ȴ
		{
			timer++;
		}
		if (timer>=0xf000)
		{
			n=read728x(0x19);
			write728x(0x19,n|0x0f);
			return;
		}
		key_number=read728x(0x13);	// ֵ
		if (key_number==0x0f)
		{
			write728x(0x12,0x8c);
		}
		if (key_number==0x00)
		{
			write728x(0x12,0x88);
		}
		n=read728x(0x12);
		if (n&0x04)
		{
			kms=1;
		}	else
			{
				kms=0;
			}
		n=read728x(0x19);
		write728x(0x19,n&0xf0);		//
		write728x(0x15,0xb0+kms);	// DIG12ʾKMSֵ
		write728x(0x14,0xaa);		// DIG11ʾ"-"
		write728x(0x15,0x90+(key_number&0xf0)/16);
							// DIG10HEX뷽ʽʾĸ4λ
		write728x(0x15,0x80+(key_number&0x0f));
							// DIG9HEX뷽ʽʾĵ4λ
		if (kms==1)
		{
			while (!key);
		}
	}
		return;
}

// ***********************************************************
// * дBC728X, һΪĿĴַ, ڶΪҪд *
// ***********************************************************
void write728x(unsigned char reg_add, unsigned char write_data)
{
	send_byte(reg_add);		// ͼĴַ
	send_byte(write_data);	// ֽ
}

// **********************************************************
// *       BC728X ڲĴֵ, òΪĴַ        *
// **********************************************************
unsigned char read728x(unsigned char reg_add)
{
	send_byte(reg_add|0x80);	// Ͷָ(bit7=1)
	return(receive_byte());	// ֽڲ
}

// ***********************************************************
// *                 BC728X һֽ                     *
// ***********************************************************
void send_byte(unsigned char send_byte)
{
	unsigned char bit_counter;
	do {				// clk 
		clk=0;
		clk=1;
 	} while (dat);		// ȴ BC728X  dat ͵ƽӦ
	clk=0;			// ٴһ clk 
	clk=1;
	while (!dat);		// ȴ BC728X ״̬
	for (bit_counter=0;bit_counter<8;bit_counter++)
	{			//  8 
		if ((send_byte&0x80)==0)
 		{
  			dat=0;// bitΪ0,  dat Ϊ 0
  	 	}
  	 	else
  	 	{
  	 		dat=1;		// ֮Ϊ 1
  	  	}
 		send_byte=send_byte*2;	// send_byte һλ
		clk=0;			// һ clk 
		clk=1;
		delay(3);		// ʱ
	}
	dat=1;				// ָ dat Ϊߵƽ
	delay(5);
}

// ************************************************************
// *                  BC728X һֽ                     *
// ************************************************************
unsigned char receive_byte(void)
{
	unsigned char bit_counter, in_byte;
	clk=0;			// һ clk 
	clk=1;
	while (dat);		// ȴ BC728X Ӧ
	clk=0;		// յӦ, һȴ
	clk=1;
	for (bit_counter=0;bit_counter<8;bit_counter++)
	{			// 8bit
		delay(3);	// ʱ
		in_byte=in_byte*2;	// in_byte һλ
		if (dat)	//  dat Ϊ'1'
		{
			in_byte=in_byte|0x01;	// bit0=1
		}
		clk=0;		// һ clk 
		clk=1;
	}
	delay(5);
	return(in_byte);
}

// ***********************************************************
// *  ʱ, ʱʱtime, ΧǼuSٸuS *
// ***********************************************************
void delay(unsigned char time)
{
	while (time!=0)
	{
		time--;
	}
}

// ************************* ʱ n*10ms *************************
void delay10ms(unsigned char time)
{
	unsigned char i;
	unsigned int j;
	for (i=0;i<time;i++)
	{
		for(j=0;j<0x390;j++)
		{
			if (!key)
			{
				key_int();
			}
		}
	}
}
