/******************************************************************************
*                       BC727XʾSTM32(FreeRTOS)                       *
*                                                                             *
* ˵BC727xʾ壬Ϊʾ, ʾʾͶȡ    *
*           (ϼͳ)BC7276, BC7277оƬ              *
* CPU: STM32F103                                                              *
* RTOS: FreeRTOS V9.0                                                         *
* Main Frequency: 72MHz                                                       *
* Ȩ: ־ȸ߿Ƽ޹˾ Bitcode Technology                       *
* 汾: V1.1                                                                *
* ߣý                                                                  *
* ʼڣ201732                                                      *
* 汾ʷ:                                                                   *
*   2017-04-06 : Ver 1.1  ޸һЩbug                                       *
******************************************************************************/

#include <stm32f10x.h>
#include "FreeRTOS.h"
#include "task.h"
#include "queue.h"


/* BC727X ָĴַ BC727X commands(register addresses) */
#define SEG_BLINK_CTL       0x10    // ˸ƼĴʼַ
#define DIG_BLINK_CTL_L     0x18    // 0-7λ˸ƼĴʼַ
#define DIG_BLINK_CTL_H     0x19    // 8-15λ˸ƼĴʼַ
#define BLINK_SPEED         0x1A    // ˸ٶȿƼĴַ
#define DECODE_HEX          0x1b    // 16ʾĴַ
#define DECODE_SEG          0x1c    // ѰַĴַ
#define WRITE_ALL           0x1d    // ȫֲĴַ
#define DUMMY_CMD           0xff    // ָ

/*   BC727XʹSPI1      */
/*   BC727X IS AT SPI1         */
/*   PA4 --- CS                */
/*   PA5 --- SCK               */
/*   PA6 --- MISO              */
/*   PA7 --- MOSI              */
/*   PC4 --- KEY               */

// I/OŶ I/O pin definition
#define BC727X_CS       0x00000010      // CS at PA4
#define BC727X_KEY      0x00000010      // KEY at PC4

// FreeRTOS task  declarations
void vSPIComm(void* vpParameter);
void vDemo(void* vpParameter);
void vKeyProcess(void* vpParameter);

// ʼRCC function to initialize RCC
void Init_RCC(void)
{
    // APB2ʱƵʺBC727XҪ
    // adjust APB2 clock rate to adapt BC727X SPI frequency
    RCC->CFGR |= RCC_CFGR_PPRE2_DIV8;       // APB2 clock = HCLK/8 (9MHz)
    
    // ʹ AFIO, IOPA, IOPC, SPI1
    RCC->APB2ENR |= RCC_APB2ENR_AFIOEN | RCC_APB2ENR_IOPAEN | RCC_APB2ENR_IOPCEN | RCC_APB2ENR_SPI1EN;
}

// ʼGPIO function to initialize GPIOs
void Init_GPIO(void)
{
    // CRL/CRH most used values:
    // 4 -- float input (default)
    // 3 -- push-pull 50MHz
    // 2 -- push-pull 2MHz
    // 1 -- push-pull 10MHz
    // B -- alternate push-pull 50MHz
    // A -- alternate push-pull 2MHz
    // 9 -- alternate push-pull 10MHz
    // 8 -- input with pull-up/pull-down
    // 0 -- analog input
    
    GPIOA->CRL = 0xA8A24444;    // CLK, MOSIΪCSΪGPIOMISOΪ/
                                // CLK, MOSI set as alternate push-pull output, CS as GPIO, MISO as pull-up/pull-down input
    GPIOA->ODR = 0x00000050;    // MISO(PA6)ΪCS(PA4)Ϊߵƽ
                                // MOSI(PA6) set as pull-up, CS(PA4) set to high
}

// ʼSPIӿں function to initialize SPI1
void Init_SPI1(void)
{
    // SPI1Ϊ16λpclk/256, ģʽclkиߵƽڵڶʱز
    // set SPI1 as 16-bit, frequency=pclk/256, master mode, clk idle high, data captured at 2nd clock phase
    // SPI1ʱƵΪ35.156KHz
    // the actual SPI1 frequency is 35.156KHz
    SPI1->CR1 = SPI_CR1_DFF | SPI_CR1_SSM | SPI_CR1_SSI | SPI_CR1_SPE | SPI_CR1_BR 
                | SPI_CR1_MSTR | SPI_CR1_CPOL | SPI_CR1_CPHA;
    // ʹRXNEж enable RXNE interrupt
    SPI1->CR2 = SPI_CR2_RXNEIE;
}

// ʼEXIT function to initialize EXTI
void Init_EXTI(void)
{
    AFIO->EXTICR[1] = AFIO_EXTICR2_EXTI4_PC;    // 4жʹ PC  EXTI line4 use Port C
    EXTI->RTSR = EXTI_RTSR_TR4;     // line4жʹ rising edge on line4
    EXTI->FTSR = EXTI_FTSR_TR4;     // line4½жʹ falling edge on line4 
    EXTI->IMR = EXTI_IMR_MR4;       // ʹline4ж enable line4 interrupt
}

// ʼNVIC function to initialize NVIC
void Init_NVIC(void)
{
    NVIC_SetPriority(SPI1_IRQn, 14);    // ʹжȼFreeRTOSSYSCALLȼ
    NVIC_SetPriority(EXTI4_IRQn, 14);   // make the interrupt priority lower than the max SYSCALL priority
    NVIC_EnableIRQ(SPI1_IRQn);      // ʹSPI1ж enable SPI1 interrupt
    NVIC_EnableIRQ(EXTI4_IRQn);     // ʹEXTI4ж enable EXTI4 interrupt
}

// ȫֱ definitions for globle variables
QueueHandle_t SPIBuffer;                                    // ʹһqueueΪSPIĻ use a queue as SPI buffer
BaseType_t ReadKeyMap, KeyStatusChanged;                    // ״̬־ used as flags for keypad status
TaskHandle_t DemoTask1, DemoTask2, SPITask, KeypadTask;     // ľ handles for tasks

int main(void)
{
    Init_RCC();
    Init_GPIO();
    Init_SPI1();
    Init_EXTI();
    SPIBuffer = xQueueCreate(4, sizeof(uint16_t));      // SPI create SPI buffer
    ReadKeyMap = pdFALSE;
    KeyStatusChanged = pdFALSE;

    // ʾ񴴽ʵ費ͬ
    // Create tasks, 2 instance are created for the Demo task
    xTaskCreate(vSPIComm, "Send buffer data via SPI", 128, NULL, 2, &SPITask);  // SPIȼΪ2() SPI task has priority set to 2(highest)
    xTaskCreate(vDemo, "Demo task1", 128, (void*)1, 1, &DemoTask1);             // ʾȼΪ1 DEMO task has priority of 1
    xTaskCreate(vDemo, "Demo task2", 128, (void*)5, 1, &DemoTask2);
    xTaskCreate(vKeyProcess, "response to key input", 128, NULL, 1, &KeypadTask);   // ̴ȼΪ1  key processing task has priority 1
    
    xTaskNotifyGive(SPITask);       // ʼSPI֪ͨԱSPI
                                    // Initialize the notifications for SPI task, so the transmitting on SPI can be started

    vTaskStartScheduler();          //  start scheduler
    while(1);           // ³򲻻ִе  normally programme will not run to here
}

// SPIͨѶ SPI task
void vSPIComm(void* vpParameter)
{
uint16_t DataToSend;
    Init_NVIC();        // гʼNVICȷǰжϷ
                        // call NVIC initialization code from task, to make sure no interrupt
                        // could happen before scheduler is started
    while(1)
    {
        xQueueReceive(SPIBuffer, &DataToSend, portMAX_DELAY);    // SPIȡ,ȴ get data from SPI buffer, wait if empty
        ulTaskNotifyTake(pdTRUE, portMAX_DELAY);        // ȴSPIӿڿ(һݷ) wait for SPI into the idle state (last data sent)
        GPIOA->BRR = BC727X_CS;             // CSΪ͵ƽ set low on CS pin
        if (pdTRUE == KeyStatusChanged)     // ״̬˱仯 if keypad status changed
        {
            ReadKeyMap = pdTRUE;            // öӳ־ set read-key-map flag
            KeyStatusChanged = pdFALSE;
        }
        SPI1->DR = DataToSend;      // дSPIӲ write data to SPI
    }
}

//  key process task
void vKeyProcess(void *vpParameter)
{
uint32_t KeyData, PreviousKey;
BaseType_t KeyWaitStat;
    PreviousKey = 0x0000ffff;
    while (1)
    {
        KeyWaitStat = xTaskNotifyWait(0, 0xFFFFFFFF, &KeyData, pdMS_TO_TICKS(1500));
        if (pdTRUE == KeyWaitStat)      // յӳ new key data received
        {
            PreviousKey = KeyData;
            if ((KeyData&0x00008000) == 0x00000000) // S9 if S9 is pressed
            {
                xTaskNotify(DemoTask2, KeyData, eSetValueWithOverwrite);    // ݷ͸DEMO2, send key data to DEMO2
            }
            else
            {
                xTaskNotify(DemoTask1, KeyData, eSetValueWithOverwrite);    // ͸DEMO1, otherwise send to DEMO1
            }
        }
        else if (0x0000FFFF != PreviousKey)     // ǰӳ䲻Ϊա1500msû״̬ûб仯, Ϊ 
                                                // current key map is not 'empty' and not changed for 1500ms, so it's
                                                // a long key press
        {
            PreviousKey |= 0x80000000;          // ó־ set long press flag
            if ((PreviousKey&0x00008000) == 0x00000000) // S15 if S15 is pressed
            {
                xTaskNotify(DemoTask2, PreviousKey, eSetValueWithOverwrite);    // ݷ͸DEMO2, send key data to DEMO2
            }
            else
            {
                xTaskNotify(DemoTask1, PreviousKey, eSetValueWithOverwrite);    // ͸DEMO1, otherwise send to DEMO1
            }
        }
    }
}
        


// ʾ DEMO task
/*
ܶ壺
S0 : ٶӣתת
S8 : ٶȼСתת
S1 : ת/ֹͣ
S15 : ѡS15ʱѡDEMO1, S15ͬʱٰƼϼ, DEMO2
*/

// תʾβ lookup table for rotating segments display
const uint8_t DispPattern[10][2] = { {0xfe,0xfe}, {0xff,0xfc}, {0xff,0xf8}, {0xff,0xf1}, {0x7f,0xf3}, 
                                    {0x77,0xf7}, {0x67,0xff}, {0xc7,0xff}, {0xce,0xff}, {0xde,0xff}};
void vDemo(void* vpParameter)
{
BaseType_t i=0;
BaseType_t Speed, Clockwise, DemoStop;
uint32_t KeyEntry;
uint16_t data;
    Speed = 5;
    Clockwise = pdTRUE;
    DemoStop = pdFALSE;
    vTaskDelay(pdMS_TO_TICKS(100)); // ȴ100msȷBC727Xλ delay 100ms to make sure BC727X reset completely
    data = (WRITE_ALL)<<8 | 0XFF;
    xQueueSend(SPIBuffer, &data, pdMS_TO_TICKS(100));    // ʱʾ clear display at start
    data = (DECODE_HEX)<<8 | (((uint8_t)vpParameter+2)<<4 | (Speed & 0x0f));
    xQueueSend(SPIBuffer, &data, pdMS_TO_TICKS(100));   // ʾٶ display speed
    data = (((uint8_t)vpParameter+1) << 8) | 0xbf;
    xQueueSend(SPIBuffer, &data, pdMS_TO_TICKS(100));   // ʾ- display '-'
    while(1)
    {
        if (pdFALSE == DemoStop)
        {
            data = ((uint8_t)vpParameter)<<8 | DispPattern[i][0];
            xQueueSend(SPIBuffer, &data, portMAX_DELAY);
            data = ((uint8_t)vpParameter-1)<<8 | DispPattern[i][1];
            xQueueSend(SPIBuffer, &data, portMAX_DELAY);
            if (pdTRUE == Clockwise)
            {
                i++;
                if (10 == i)
                {
                    i = 0;
                }
            }
            else
            {
                if (0 == i)
                {
                    i = 10;
                }
                i--;
            }
        }
        vTaskDelay(pdMS_TO_TICKS(20*(10-Speed)));
        if (xTaskNotifyWait(0, 0xffffffff, &KeyEntry, 0) == pdTRUE) //յ֪ͨ if notification received
        {
            KeyEntry |= 0x00008000;     // S9 mask S9
            if ((0x8000fffe == KeyEntry) || (0x8000feff == KeyEntry))   // S0S8 if S0 or S8 long pressed
            {
                Clockwise = Clockwise == pdTRUE ? pdFALSE : pdTRUE;
            }
            else if ((0x0000fffe == KeyEntry) && (Speed < 9))
            {
                Speed++;
                data = (DECODE_HEX)<<8 | (((uint8_t)vpParameter+2)<<4 | (Speed & 0x0f));
                xQueueSend(SPIBuffer, &data, pdMS_TO_TICKS(100));   // ʾٶ display speed
                }
            else if ((0x0000feff == KeyEntry) && (Speed >1))
            {
                Speed--;
                data = (DECODE_HEX)<<8 | (((uint8_t)vpParameter+2)<<4 | (Speed & 0x0f));
                xQueueSend(SPIBuffer, &data, pdMS_TO_TICKS(100));   // ʾٶ display speed
            }
            else if (0x0000fffd == KeyEntry)
            {
                DemoStop = DemoStop == pdTRUE ? pdFALSE : pdTRUE;
            }
        }
    }
}


// SPI1жϷ ISR for SPI1
/*
ΪSPI1ֻʹRXNEһжԴISRвжжԴжϱ־λڶݼĴʱԶ
жʹ֪ͨͬSPI񣬸֪һѾɣӳ־λȡ
ӳ䲢֪ͨ͸̴
As there's only RXNE one source enabled for SPI1 interrupt, there's no need to check the interrupt source
Pending bit is cleared automatically while reading the data register.
The ISR uses task notifications to inform the SPI task that the current transmitting is completed,
if read-key-map flag was set then the key map is sent to keypad processing task via task notification too.
*/
void SPI1_IRQHandler(void)
{
uint32_t KeyMap;    // Ϊ֪ͨԶ32λӳҲΪ32λ
                    // as the task notification is alway 32-bit, the variables
                    // is defined as 32-bit too
BaseType_t xHigherPriorityTaskWoken;    // лָʾ־ flag used to switch context
    xHigherPriorityTaskWoken = pdFALSE;
    KeyMap = (uint32_t)SPI1->DR;        // ȡӳ read key map
    GPIOA->BSRR = BC727X_CS;            // ƬѡΪߵƽ set chip select as high
    vTaskNotifyGiveFromISR(SPITask, &xHigherPriorityTaskWoken);     // SPISPIӿڿ֪ͨ send SPI idle notification to SPI task
    if (pdTRUE == ReadKeyMap)
    {
        // ͼӳ send key map
        xTaskNotifyFromISR(KeypadTask, KeyMap, eSetValueWithOverwrite, &xHigherPriorityTaskWoken);
        ReadKeyMap = pdFALSE;
    }
    portYIELD_FROM_ISR(xHigherPriorityTaskWoken);   // бҪл switch task if necessary
}

// EXTI4жϷ ISR for EXTI4
/*
ⲿж4KEYţ״̬仯ʱKEYŵƽҲ仯
жϷֻü̱仯־αָ뷢ͶУ
ȷݼʱȡüӳ
EXTI line4 is connected with BC727X's KEY pin, the level on KEY changes as the keypad status changed.
the ISR only set the flag for keypad changing, and put dummy command in the sending queue,
to make sure there's data sending on SPI to get the key mapping data in time
*/
void EXTI4_IRQHandler(void)
{
    EXTI->PR |= EXTI_PR_PR4;    // жϱ־ clear line4 pending bit
    xQueueSendFromISR(SPIBuffer, (void*)0xffff, NULL);  // αָ add dummy command to queue
    KeyStatusChanged = pdTRUE;      // ü̱仯־ set the keypad changing flag
}
    
