/******************************************************************************
*                    BC7275AʾSTC                                     *
*                                                                             *
* ˵BC7275Aʾ壬ʾоƬĸ. Ϊͨʾ,  *
*           BC7275AоƬδʹж, 6MHzϵͳʱ(ȱʡʹڲRC) *
* Ȩ: ־ȸ߿Ƽ޹˾ Bitcode Technology                       *
* 汾: V1.0                                                                *
* ʼڣ20171114                                                    *
* 汾ʷ:                                                                   *
*  V1.0  -                                                                    *
******************************************************************************/


#include <stc12.h>
#include <stdlib.h>		// Ϊʹ rand() 

#define SPI_CS  		P1_4	// BC727XоƬCSP1.4(BC7275AûCS
                                // ţ˴ΪBC727XоƬ
#define MISO			P1_5	// BC727XMISOP1.5 (BC7275Aûдţ
                                // ˴ MISO ΪʹBC727XоƬһ
#define MOSI			P1_6	// BC727XMOSIP1.6
#define SPI_CLK			P1_7	// CLKP1.7

#define SEG_BLINK_CTL		0x10	// ˸ƼĴʼַ(8ֽ)
#define DIG_BLINK_CTL_L		0x18	// 0-7λ˸ƼĴʼַ
#define DIG_BLINK_CTL_H		0x19	// 8-15λ˸ƼĴʼַ
#define BLINK_SPEED			0x1A	// ˸ٶȿƼĴַ
#define DECODE_HEX			0x1b	// 16ʾĴַ 
#define DECODE_SEG			0x1c	// ѰַĴַ
#define WRITE_ALL			0x1d	// ȫֲĴַ

// ƶʾõĶεַ
const unsigned char clockRun[]={16, 8, 0, 1, 2, 3, 11, 19, 20, 21};
const unsigned char upNDown[]={19, 22, 16, 43, 46, 40, 11, 14, 8, 35, 38, 32, 3, 6, 0, 27, 30, 24};
// ʾõ
const unsigned char bar[12][3]={
	{0,1,1},
	{1,2,2},
	{2,3,3},
	{2,4,3},
	{2,5,3},
	{2,6,4},
	{3,6,4},
	{4,6,3},
	{5,6,3},
	{6,5,4},
	{6,4,3},
	{6,3,3}};

/*****************************************************************************
 ͨSPIڷһֽ
 룺Ҫ͵ֽ
 ֵSPIڽյֽ
*****************************************************************************/
unsigned char spiSendByte(unsigned char dat);


/*****************************************************************************
 ܣͨSPIڷһBC727Xָ
 룺ĿĴַ, дĴ
 ֵSPIڽյ(16λΪӳĴݣBC7275Aûм̣
         ˷ֵΪBC727XоƬһ) 
*****************************************************************************/
unsigned short spiSendCmd(unsigned char reg, unsigned char dat);



/****************************************************************************
 ʱʱ @ 12MHz(ͬMCUעִʱ)
 룺-
 ֵvoid
****************************************************************************/
void delayHalfT(void);


/****************************************************************************
 ܣʱ n*10 ms @ 6MHz
 룺n
 ֵvoid
****************************************************************************/
void delay10ms(unsigned short n);

/****************************************************************************
 ܣʾ
 룺(L)(M),(R) ĸ߶ȣȡֵΧΪ0-6
 ֵvoid
****************************************************************************/
void dispBar(unsigned char L, unsigned char M, unsigned char R);


/****************************************************************************
 ܣʾ
 룺ʾλposʾֵn 
 ֵvoid
****************************************************************************/
void dispNum(unsigned char pos, unsigned short n);



int main(void)
{
	unsigned char i;
	unsigned char j;
	short num1;
	short num2;
	
	SPI_CS = 1;			// BC7275AûCSţдΪBC727X
	delay10ms(10);			// ʱԼ100msȷBC7275Aɸλ
	spiSendCmd(BLINK_SPEED,0x09);		// ˸ٶΪ0x09
	// spiSendCmd(DIG_BLINK_CTL_H, 0x01);	// 8λ˸ʾ
	// spiSendCmd(0x08, 0xf7);			// 8λʾ"_"
	// spiSendCmd(DECODE_HEX, 0x20|(countSpeed%10));			// ڵ23λʾٶ
	// spiSendCmd(DECODE_HEX, 0x30|((countSpeed/10)%10));
	while (1)
	{
		spiSendCmd(WRITE_ALL,0xff);		// ʾ
		for (j=0; j<5; j++)     // ת5Ȧ
		{
			for (i=0; i<10; i++)    // ÿȦ10λ
			{
				spiSendCmd(DECODE_SEG, clockRun[i]);        // һ
				spiSendCmd(DECODE_SEG, 24+clockRun[9-i]);   // ڶ
				delay10ms(7);
				spiSendCmd(DECODE_SEG, 0x80|clockRun[i]);           // رյһ
				spiSendCmd(DECODE_SEG, 0x80|(24+clockRun[9-i]));    // رյڶ
			}
		}
		for (i=0; i<18; i++)    // εܵĺʾʾ 
		{
			spiSendCmd(DECODE_SEG, upNDown[i]);
			delay10ms(15);
		}
		delay10ms(150);
		for (i=0; i<18; i++)    // ιرոܵĺʾ
		{
			spiSendCmd(DECODE_SEG, 0x80|upNDown[i]);
			delay10ms(15);
		}
		delay10ms(200);
		spiSendCmd(SEG_BLINK_CTL+3, 0x01);      // õ 345λܵaΪ˸ʾ
		spiSendCmd(SEG_BLINK_CTL+4, 0x01);
		spiSendCmd(SEG_BLINK_CTL+5, 0x01);
		for (j=0; j<2; j++)     // ʾѭʾ2
		{
			for (i=0; i<12; i++)    // ÿʾ仯12
			{
				dispBar(bar[i][0], bar[i][1], bar[i][2]);
				delay10ms(10);
			}
			delay10ms(200);
			for (i=0; i<12; i++)
			{
				dispBar(bar[11-i][0], bar[11-i][1], bar[11-i][2]);
				delay10ms(10);
			}
		}
		delay10ms(200);
		spiSendCmd(SEG_BLINK_CTL+3, 0);
		spiSendCmd(SEG_BLINK_CTL+4, 0);
		spiSendCmd(SEG_BLINK_CTL+5, 0);
		spiSendCmd(DECODE_SEG, 23);     // С
		spiSendCmd(DECODE_SEG, 47);
		for (i=0; i<3; i++)
		{
			num1 = rand()%1000;     // õ,ȡֵΧ 0-999
			num2 = rand()%1000;
			dispNum(0, num1);       // ʾ ʾʽΪ 0.00-9.99 С
			dispNum(3, num2);
			while (num1 != num2)    // ֲȣ12£
			{
				if (num2 > num1)
				{
					++num1;
				}
				if (num2 < num1)
				{
					--num1;
				}
				delay10ms( (abs(num1-num2)>10) ? 0:(50-5*abs(num1-num2)) );     // 10ʱٱ仯С10ʱ仯ٶȵݼʱӳ
				dispNum(0, num1);
			}
			spiSendCmd(DIG_BLINK_CTL_L, 0x3F);      // Ⱥ˸ʾ5
			delay10ms(500);
			spiSendCmd(DIG_BLINK_CTL_L, 0);         // ֹͣ˸
		}	
	}
}

void dispNum(unsigned char pos, unsigned short n)
{
	pos <<= 4;
	spiSendCmd(DECODE_HEX, pos|(n%10));
	n /= 10;
	spiSendCmd(DECODE_HEX, (pos+0x10)|(n%10));
	n /= 10;
	spiSendCmd(DECODE_HEX, (pos+0x20)|(n%10));
}

void dispBar(unsigned char L, unsigned char M, unsigned char R)
{
	unsigned char i;
	for (i=0; i<6; i++)
	{
			spiSendCmd(DECODE_SEG, upNDown[i] | (L>i ? 0:0x80));
			spiSendCmd(DECODE_SEG, upNDown[i+6] | (M>i ? 0:0x80));
			spiSendCmd(DECODE_SEG, upNDown[i+12] | (R>i ? 0:0x80));
	}
}

/*****************************************************************************
 ͨSPIڷһBC727Xָ
 룺ĿĴַ, дĴ
 ֵSPIڽյ(16λΪӳĴ)
*****************************************************************************/
unsigned short spiSendCmd(unsigned char reg, unsigned char dat)
{
	unsigned short r16;
	delayHalfT();
	 SPI_CS = 0;	// BC7275AûCSţдΪBC727X
	r16 = spiSendByte(reg)*0x100;
	r16 |= spiSendByte(dat);
	 SPI_CS = 1;	// BC7275AûCSţдΪBC727X
	return r16;
}



/*****************************************************************************
 ͨSPIڷһֽ
 룺Ҫ͵ֽ
 ֵSPIڽյֽ
*****************************************************************************/
unsigned char spiSendByte(unsigned char dat)
{
	unsigned char i, rdByte;
	delayHalfT();		// ʱʱ
	for (i=0; i<8; i++)
	{
		if (dat&0x80)
		{
			MOSI = 1;
		}
		else
		{
			MOSI = 0;
		}
		SPI_CLK = 0;
		delayHalfT();
		rdByte <<= 1;
		if (MISO)
		{
			rdByte |= 0x01;
		}
		SPI_CLK = 1;
		delayHalfT();
		dat <<= 1;
	}
	return rdByte;
}


/****************************************************************************
 ʱʱ @ 6MHz(1T mode) (ͬMCUעִʱ)
 룺-
 ֵvoid
****************************************************************************/
void delayHalfT(void)
{
	unsigned char i;
	for (i=0; i<48; i++)
	{
		__asm__("nop");	// ӳʱԼ8uS @ 6MHz(1T mode) (δкͷʱ)
	}
}



/****************************************************************************
 ʱ n*10ms @ 6MHz (1T ģʽ)
 룺n
 ֵvoid
****************************************************************************/
void delay10ms(unsigned short n)
{
	unsigned short j;
	while(n != 0)
	{
		--n;
		for(j=0;j<2680;j++)
		{
		}
	}
}
