#ifndef FONT8PX_H
#define FONT8PX_H

/********************************************************************************
*                         8像素可变宽度中英文点阵字库使用说明
*
* 本字库包含全部英文键盘字符及部分汉字和特殊符号，适用于BC7591芯片驱动的32*8 LED
* 点阵显示，但也可用于任何8行分辨率的点阵显示。
*
* 每个字符的字库数据由2部分组成，第一个字节为字符宽度，即该字符在横向由多少像素
* 组成，从第二个字节起，为字符的点阵映射数据，数据由左至右排列，即第一个数据字节
* 对应字符点阵最左侧一列。bit0对应最底行，bit7对应最顶行。
*
* 字库采用可变宽度，如字母'i'宽度为3，占用3个列，而汉字"时"的宽度则为7,占用7列。
* 可变宽度字库可使得显示更紧凑美观，更适用于小尺寸屏幕。
*
* 本字库排列顺序任意，不要求按编码顺序排列，因此也可以任意裁剪，可以只截取用到的
* 字符使用，节约空间。
*
* 每个字符都定义为一个数组，都有一个特定名称，使用时只要建立一个字库数组的入口
* 地址表，根据要显示的字符获得相应的入口地址，即可读取字符点阵映射完成显示。
* 具体应用请参考《BC7591驱动点阵显示中英文字符例子程序》
*********************************************************************************/

const unsigned char En_A[] = { 0x05, 0x7e, 0x90, 0x90, 0x90, 0x7e };        // 'A'
const unsigned char En_B[] = { 0x05, 0xfe, 0x92, 0x92, 0x92, 0x6c };        // 'B'
const unsigned char En_C[] = { 0x05, 0x7c, 0x82, 0x82, 0x82, 0x82 };        // 'C'
const unsigned char En_D[] = { 0x05, 0xfe, 0x82, 0x82, 0x82, 0x7c };        // 'D'
const unsigned char En_E[] = { 0x05, 0xfe, 0x92, 0x92, 0x92, 0x82 };        // 'E'
const unsigned char En_F[] = { 0x05, 0xfe, 0x90, 0x90, 0x90, 0x80 };        // 'F'
const unsigned char En_G[] = { 0x05, 0x7c, 0x82, 0x92, 0x92, 0x5e };        // 'G'
const unsigned char En_H[] = { 0x05, 0xfe, 0x10, 0x10, 0x10, 0xfe };        // 'H'
const unsigned char En_I[] = { 0x03, 0x82, 0xfe, 0x82 };                    // 'I'
const unsigned char En_J[] = { 0x04, 0x04, 0x82, 0xfe, 0x80 };              // 'J'
const unsigned char En_K[] = { 0x05, 0xfe, 0x10, 0x28, 0x44, 0x82 };        // 'K'
const unsigned char En_L[] = { 0x05, 0xfe, 0x02, 0x02, 0x02, 0x02 };        // 'L'
const unsigned char En_M[] = { 0x05, 0xfe, 0x40, 0x30, 0x40, 0xfe };        // 'M'
const unsigned char En_N[] = { 0x05, 0xfe, 0x20, 0x10, 0x08, 0xfe };        // 'N'
const unsigned char En_O[] = { 0x05, 0x7c, 0x82, 0x82, 0x82, 0x7c };        // 'O'
const unsigned char En_P[] = { 0x05, 0xfe, 0x90, 0x90, 0x90, 0x60 };        // 'P'
const unsigned char En_Q[] = { 0x05, 0x7c, 0x82, 0x8a, 0x84, 0x7a };        // 'Q'
const unsigned char En_R[] = { 0x05, 0xfe, 0x90, 0x98, 0x94, 0x62 };        // 'R'
const unsigned char En_S[] = { 0x05, 0x62, 0x92, 0x92, 0x92, 0x8c };        // 'S'
const unsigned char En_T[] = { 0x05, 0x80, 0x80, 0xfe, 0x80, 0x80 };        // 'T'
const unsigned char En_U[] = { 0x05, 0xfc, 0x02, 0x02, 0x02, 0xfc };        // 'U'
const unsigned char En_V[] = { 0x05, 0xf8, 0x04, 0x02, 0x04, 0xf8 };        // 'V'
const unsigned char En_W[] = { 0x05, 0xfc, 0x02, 0x1c, 0x02, 0xfc };        // 'W'
const unsigned char En_X[] = { 0x05, 0xc6, 0x28, 0x10, 0x28, 0xc6 };        // 'X'
const unsigned char En_Y[] = { 0x05, 0xc0, 0x20, 0x1e, 0x20, 0xc0 };        // 'Y'
const unsigned char En_Z[] = { 0x05, 0x86, 0x8a, 0x92, 0xa2, 0xc2 };        // 'Z'

const unsigned char En_a[] = { 0x04, 0x1c, 0x22, 0x22, 0x3e };              // 'a'
const unsigned char En_b[] = { 0x04, 0xfe, 0x22, 0x22, 0x1c };              // 'b'
const unsigned char En_c[] = { 0x04, 0x1c, 0x22, 0x22, 0x22 };              // 'c'
const unsigned char En_d[] = { 0x04, 0x1c, 0x22, 0x22, 0xfe };              // 'd'
const unsigned char En_e[] = { 0x04, 0x1c, 0x2a, 0x2a, 0x1a };              // 'e'
const unsigned char En_f[] = { 0x04, 0x20, 0x7e, 0xa0, 0x80 };              // 'f'
const unsigned char En_g[] = { 0x04, 0x38, 0x45, 0x45, 0x7e };              // 'g'
const unsigned char En_h[] = { 0x04, 0xfe, 0x20, 0x20, 0x1e };              // 'h'
const unsigned char En_i[] = { 0x03, 0x22, 0xbe, 0x22 };                    // 'i'
const unsigned char En_j[] = { 0x03, 0x21, 0xa1, 0x3e };                    // 'j'
const unsigned char En_k[] = { 0x04, 0xfe, 0x08, 0x14, 0x22 };              // 'k'
const unsigned char En_l[] = { 0x03, 0x82, 0xfe, 0x02 };                    // 'l'
const unsigned char En_m[] = { 0x05, 0x3e, 0x20, 0x1e, 0x20, 0x1e };        // 'm'
const unsigned char En_n[] = { 0x04, 0x3e, 0x20, 0x20, 0x1e };              // 'n'
const unsigned char En_o[] = { 0x04, 0x1c, 0x22, 0x22, 0x1c };              // 'o'
const unsigned char En_p[] = { 0x04, 0x7f, 0x44, 0x44, 0x38 };              // 'p'
const unsigned char En_q[] = { 0x04, 0x38, 0x44, 0x44, 0x7f };              // 'q'
const unsigned char En_r[] = { 0x04, 0x3e, 0x20, 0x20, 0x10 };              // 'r'
const unsigned char En_s[] = { 0x04, 0x1a, 0x2a, 0x2a, 0x2c };              // 's'
const unsigned char En_t[] = { 0x04, 0x20, 0xfc, 0x22, 0x02 };              // 't'
const unsigned char En_u[] = { 0x04, 0x3c, 0x02, 0x02, 0x3e };              // 'u'
const unsigned char En_v[] = { 0x05, 0x38, 0x04, 0x02, 0x04, 0x38 };        // 'v'
const unsigned char En_w[] = { 0x05, 0x3c, 0x02, 0x1c, 0x02, 0x3c };        // 'w'
const unsigned char En_x[] = { 0x04, 0x36, 0x08, 0x08, 0x36 };              // 'x'
const unsigned char En_y[] = { 0x04, 0x78, 0x05, 0x05, 0x7e };              // 'y'
const unsigned char En_z[] = { 0x04, 0x26, 0x2a, 0x2a, 0x32 };              // 'z'

const unsigned char En_0[] = { 0x05, 0x7c, 0x8a, 0x92, 0xa2, 0x7c };        // '0'
const unsigned char En_1[] = { 0x03, 0x42, 0xfe, 0x02 };                    // '1'
const unsigned char En_2[] = { 0x05, 0x4e, 0x92, 0x92, 0x92, 0x62 };        // '2'
const unsigned char En_3[] = { 0x05, 0x44, 0x92, 0x92, 0x92, 0x6c };        // '3'
const unsigned char En_4[] = { 0x05, 0x18, 0x28, 0x48, 0xfe, 0x08 };        // '4'
const unsigned char En_5[] = { 0x05, 0xf2, 0x92, 0x92, 0x92, 0x8c };        // '5'
const unsigned char En_6[] = { 0x05, 0x7c, 0x92, 0x92, 0x92, 0x0c };        // '6'
const unsigned char En_7[] = { 0x05, 0x80, 0x8e, 0x90, 0xa0, 0xc0 };        // '7'
const unsigned char En_8[] = { 0x05, 0x6c, 0x92, 0x92, 0x92, 0x6c };        // '8'
const unsigned char En_9[] = { 0x05, 0x60, 0x92, 0x92, 0x92, 0x7c };        // '9'

const unsigned char En_comma[]      = { 0x02, 0x05, 0x06 };                          // ','
const unsigned char En_lessthan[]   = { 0x03, 0x10, 0x28, 0x44 };                    // '<'
const unsigned char En_period[]     = { 0x02, 0x06, 0x06 };                          // '.'
const unsigned char En_morethan[]   = { 0x03, 0x44, 0x28, 0x10 };                    // '>'
const unsigned char En_colon[]      = { 0x02, 0x36, 0x36 };                          // ':'
const unsigned char En_semi[]       = { 0x02, 0x35, 0x36 };                          // ';'
const unsigned char En_quotation[]  = { 0x03, 0xe0, 0x00, 0xe0 };                    // '"'
const unsigned char En_singlequot[] = { 0x01, 0xe0 };                                // '''
const unsigned char En_question[]   = { 0x05, 0x40, 0x80, 0x8a, 0x90, 0x60 };        // '?'
const unsigned char En_slash[]      = { 0x04, 0x04, 0x08, 0x10, 0x20 };              // '/'
const unsigned char En_underscore[] = { 0x04, 0x01, 0x01, 0x01, 0x01 };              // '_'
const unsigned char En_hyphen[]     = { 0x04, 0x10, 0x10, 0x10, 0x10 };              // '-'
const unsigned char En_plus[]       = { 0x05, 0x10, 0x10, 0x7e, 0x10, 0x10 };        // '+'
const unsigned char En_equal[]      = { 0x04, 0x28, 0x28, 0x28, 0x28 };              // '='
const unsigned char En_bracel[]     = { 0x03, 0x10, 0x6c, 0x82 };                    // '{'
const unsigned char En_bracer[]     = { 0x03, 0x82, 0x6c, 0x10 };                    // '}'
const unsigned char En_bracketl[]   = { 0x02, 0x7e, 0x42 };                          // '['
const unsigned char En_bracketr[]   = { 0x02, 0x42, 0x7e };                          // ']'
const unsigned char En_pipe[]       = { 0x01, 0xff };                                // '|'
const unsigned char En_backslash[]  = { 0x4, 0x20, 0x10, 0x08, 0x04 };               // '\'
const unsigned char En_tilde[]      = { 0x04, 0x40, 0x80, 0x40, 0x80 };              // '~'
const unsigned char En_grave[]      = { 0x02, 0x80, 0x40 };                          // '`'
const unsigned char En_exclam[]     = { 0x02, 0xfb, 0xfb };                          // '!'
const unsigned char En_at[]         = { 0x05, 0x4c, 0x92, 0x9e, 0x82, 0x7c };        // '@'
const unsigned char En_hash[]       = { 0x05, 0x28, 0xfe, 0x28, 0xfe, 0x28 };        // '#'
const unsigned char En_dollar[]     = { 0x05, 0x24, 0x54, 0xfe, 0x54, 0x48 };        // '$'
const unsigned char En_percent[]    = { 0x05, 0xc4, 0xc8, 0x10, 0x26, 0x46 };        // '%'
const unsigned char En_caret[]      = { 0x05, 0x20, 0x40, 0x80, 0x40, 0x20 };        // '^'
const unsigned char En_and[]        = { 0x05, 0x6c, 0x92, 0xaa, 0x44, 0x0a };        // '&'
const unsigned char En_asterisk[]   = { 0x05, 0x28, 0x10, 0x7c, 0x10, 0x28 };        // '*'
const unsigned char En_parenl[]     = { 0x02, 0x3c, 0x42 };                          // '('
const unsigned char En_parenr[]     = { 0x02, 0x42, 0x3c };                          // ")'
const unsigned char En_space[]      = { 0x03, 0x00, 0x00, 0x00 };                    // ' '

const unsigned char Ch_nian[]       = { 0x06, 0x24, 0xdc, 0x54, 0x7f, 0x54, 0x44 };              // '年'
const unsigned char Ch_yue[]        = { 0x06, 0x02, 0xfc, 0xa8, 0xa8, 0xa8, 0xfe };              // '月'
const unsigned char Ch_ri[]         = { 0x05, 0xfe, 0x92, 0x92, 0x92, 0xfe };                    // '日'
const unsigned char Ch_shi[]        = { 0x07, 0x7e, 0x52, 0x7e, 0x50, 0x49, 0xfe, 0x40 };        // '时'
const unsigned char Ch_fen[]        = { 0x07, 0x20, 0x51, 0x9e, 0x10, 0x92, 0x5f, 0x20 };        // '分'
const unsigned char Ch_zuo[]        = { 0x06, 0x24, 0x29, 0x39, 0xef, 0x29, 0x29 };              // '左'
const unsigned char Ch_you[]        = { 0x07, 0x24, 0x28, 0x3f, 0xe9, 0x29, 0x2f, 0x20 };        // '右'
const unsigned char Ch_shang[]      = { 0x05, 0x02, 0x02, 0x7e, 0x12, 0x12 };                    // '上'
const unsigned char Ch_xia[]        = { 0x05, 0x40, 0x40, 0x7e, 0x50, 0x48 };                    // '下'
const unsigned char Ch_zhong[]      = { 0x05, 0x38, 0x28, 0x7e, 0x28, 0x38 };                    // '中'
const unsigned char Ch_wu[]         = { 0x05, 0x28, 0x68, 0x3e, 0x28, 0x28 };                    // '午'
const unsigned char Ch_yuan[]       = { 0x05, 0x12, 0x5c, 0x50, 0x5e, 0x12 };                    // '元'
const unsigned char Ch_dian[]       = { 0x07, 0x1d, 0x14, 0x15, 0xf4, 0x55, 0x54, 0x1d };        // '点'
const unsigned char Ch_yin[]        = { 0x05, 0xa8, 0x68, 0x3e, 0x68, 0xa8 };                    // '￥'
const unsigned char Ch_jiao[]       = { 0x06, 0x21, 0x7e, 0xaa, 0xff, 0xaa, 0x3f };              // '角'
const unsigned char Ch_degree[]     = { 0x06, 0xc0, 0xc0, 0x3c, 0x42, 0x42, 0x24 };              // '℃'
const unsigned char Ch_xiang[]      = { 0x07, 0x3f, 0x20, 0x6e, 0xaa, 0x2e, 0x20, 0x3f };        // '向'
const unsigned char Ch_arrowleft[]  = { 0x07, 0x10, 0x38, 0x7c, 0xfe, 0x38, 0x38, 0x38 };        // '←'
const unsigned char Ch_arrowright[] = { 0x07, 0x38, 0x38, 0x38, 0xfe, 0x7c, 0x38, 0x10 };        // '→'

#endif
